/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.decorative.solid.BuddingCertusQuartzBlock;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemDefinitionFilter;
import appeng.util.inv.filter.IAEItemFilter;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.util.FCUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public class TileCrystalFixer
extends AENetworkInvBlockEntity
implements IGridTickable {
    private int progress = 0;
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 1);

    public TileCrystalFixer(class_2338 pos, class_2680 blockState) {
        super(FCUtil.getTileType(TileCrystalFixer.class, TileCrystalFixer::new, (class_2248)EAEItemAndBlock.CRYSTAL_FIXER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.inv.setFilter((IAEItemFilter)new AEItemDefinitionFilter(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(2, 10, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.doWork(ticksSinceLastCall)) {
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    private boolean needGrowth(class_2680 blockState) {
        return blockState.method_27852(AEBlocks.DAMAGED_BUDDING_QUARTZ.block()) || blockState.method_27852(AEBlocks.CHIPPED_BUDDING_QUARTZ.block()) || blockState.method_27852(AEBlocks.QUARTZ_BLOCK.block());
    }

    private boolean doWork(int ticksSinceLastCall) {
        if (this.method_10997() == null || !this.checkFuel()) {
            return false;
        }
        class_2338 blockPos = this.method_11016().method_10081(this.getFront().method_10163());
        class_2680 blockState = this.method_10997().method_8320(blockPos);
        class_5819 random = this.method_10997().method_8409();
        if (this.needGrowth(blockState)) {
            if (this.userPower(ticksSinceLastCall * 50) > 0L) {
                this.progress += random.method_43048(5);
                this.consumeFuel(random);
            }
            if (this.progress >= 100) {
                if (blockState.method_27852(AEBlocks.QUARTZ_BLOCK.block())) {
                    this.method_10997().method_8501(blockPos, ((BuddingCertusQuartzBlock)AEBlocks.DAMAGED_BUDDING_QUARTZ.block()).method_9564());
                } else if (blockState.method_27852(AEBlocks.DAMAGED_BUDDING_QUARTZ.block())) {
                    this.method_10997().method_8501(blockPos, ((BuddingCertusQuartzBlock)AEBlocks.CHIPPED_BUDDING_QUARTZ.block()).method_9564());
                } else if (blockState.method_27852(AEBlocks.CHIPPED_BUDDING_QUARTZ.block())) {
                    this.method_10997().method_8501(blockPos, ((BuddingCertusQuartzBlock)AEBlocks.FLAWED_BUDDING_QUARTZ.block()).method_9564());
                }
                this.progress = 0;
            }
            return true;
        }
        this.progress = 0;
        return false;
    }

    private boolean checkFuel() {
        return !this.inv.getStackInSlot(0).method_7960();
    }

    private void consumeFuel(class_5819 random) {
        if (random.method_43048(10) < 1) {
            this.inv.extractItem(0, 1, false);
        }
    }

    public int getProgress() {
        return this.progress;
    }

    private long userPower(int value) {
        if (this.getGridNode() == null) {
            return 0L;
        }
        IGrid grid = this.getGridNode().getGrid();
        if (grid != null) {
            return (long)grid.getEnergyService().extractAEPower((double)value, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return 0L;
    }

    protected boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        this.inv.setItemDirect(0, data.method_10819());
        return changed;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.method_10793(this.inv.getStackInSlot(0));
    }

    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.BACK));
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("progress", this.progress);
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.progress = data.method_10550("progress");
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.markForUpdate();
    }

    public void refuel(class_1657 player) {
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((class_2586)this), (class_1657)player)) {
            return;
        }
        class_1661 playerInv = player.method_31548();
        class_1799 held = playerInv.method_7391();
        if (held.method_7960()) {
            class_1799 stuff = this.inv.extractItem(0, Integer.MAX_VALUE, false);
            if (!stuff.method_7960()) {
                playerInv.method_7398(stuff);
            }
        } else {
            class_1799 notAdded = this.inv.insertItem(0, held, false);
            playerInv.method_5447(playerInv.field_7545, notAdded);
        }
    }
}

